#ifndef DX_VOS_version_H
#define DX_VOS_version_H

#include "DX_VOS_BaseTypes.h"

#ifdef __cplusplus
extern "C"
{
#endif


/* the DX_VOS API Version release definitions */
#define DX_VOS_API_MAJOR_VERSION_NUM     6
#define DX_VOS_API_MINOR_VERSION_NUM     2
#define DX_VOS_API_SUB_VERSION_NUM       0
#define DX_VOS_API_INTERNAL_VERSION_NUM  0

#define DX_VOS_API_NAME  "VOS API"


typedef struct
{
   DxInt8 m_compName[10];
   DxUint32 m_major;
   DxUint32 m_minor;
   DxUint32 m_sub;
   DxUint32 m_internal;   
}DX_VOS_ComponentVersion_t;

typedef struct
{
   DX_VOS_ComponentVersion_t DX_VOS_API_Version;
   DX_VOS_ComponentVersion_t DX_VOS_Platform_Version;
}DX_VOS_Version_t;


/* Returns the DX_VOS version.
 The version contains the following fields:
 - compName - A string describing the nature of the release.
 - major, minor, sub, internal - the release digits.
 The version include two components: API and OS dependent implementation.
 each component have its own version. 
 */

IMPORT_C void DX_VOS_GetVersion(DX_VOS_Version_t *version);

#ifdef DX_USE_LEGACY_VOS
#define compName	m_compName
#define major		m_major
#define minor		m_minor
#define sub			m_sub
#define internal	m_internal
#endif

#ifdef __cplusplus
}
#endif

#endif


